
require( "scripts/style.lua" );

SetPauseMenuCanShow(false);
SetConfirmExitCanShow(true);
SetGamePause(false);

MakeDialog
{
    CDGameLoop
    {
        name="cdgameloop",
        x = 0,
        y = 0,
        w = 800,
        h = 600,

        CDPanelStars
        {
            name = "cdpanelstars",

            x = 30,
            y = -100,
            w = 205,
            h = 70,

            start_pos_x=30,
            start_pos_y=-100,
            
            end_pos_x=30,
            end_pos_y=0,
            
            move_speed=500,
            
            Bitmap
            {
                image = "ui/surfaces/panel_stars",
                x=0,
                y=0,
            },
        },

        CDPanelStatus
        {
            name="cdpanelstatus",
            x = 0,
            y = 620,
            w = 800,
            h = 78,
            
            start_pos_x=0,
            start_pos_y=620,
            
            end_pos_x=0,
            end_pos_y=522,
            
            move_speed=500,
            
            timer_pos_x=564,
            timer_pos_y=46,
            
            progress_pos_x=364,
            progress_pos_y=18,
            
            Bitmap
            {
                name = "panel_score",
                image = "ui/surfaces/panel_score",
                x=kCenter,
                y=0,

                SetStyle(CreateTextStyle(FontGame, 20, WhiteColor)),
                Text
                {
                    name="open",
                    --label="open",
                    x=475,y=kCenter + 16,
                    w=60,h=kMax,
                    flags=kHAlignCenter+kVAlignCenter,


         			SetStyle(CreateTextStyle(FontGame, 20, BlackColor)),
                	CreateText(0,0,"open",2,2),
					SetStyle(CreateTextStyle(FontGame, 20, WhiteColor)),
        	        CreateText(0,0,"open",0,0),
                },

                SetStyle(CreateTextStyle(FontGame, 20, RedColor)),
                Text
                {
                    name="closed",
                    ---label="closed",
                    x=475,y=kCenter + 16,
                    w=66,h=kMax,
                    flags=kHAlignCenter+kVAlignCenter,

					SetStyle(CreateTextStyle(FontGame, 20, WhiteColor)),
                	CreateText(0,0,"closed",2,2),
					SetStyle(CreateTextStyle(FontGame, 20, DarkRedColor)),
        	        CreateText(0,0,"closed",0,0),
                },
                
                SetStyle(CreateTextStyle(FontGame, 18, BlackColor)),
                Text
                {
                    name="level",
                    x=180,y=kCenter + 18,
                },
                
                SetStyle(CreateTextStyle(FontGame, 16, BlackColor)),
                Text
                {
                    name="goal",
                    label="goal",
                    x=160,y=kCenter + 10,
                    w=50,h=kMax,
                    flags=kHAlignCenter+kVAlignCenter,
                },

                SetStyle(CreateTextStyle(FontGame, 16, BlackColor)),
                Text
                {
                    name="expert",
                    label="expert",
                    x=160,y=kCenter + 10,
                    w=50,h=kMax,
                    flags=kHAlignCenter+kVAlignCenter,
                },

                SetStyle(CreateTextStyle(FontGame, 19, BlackColor)),
                Text
                {
                    name="goal_expert_score",
                    x=160,y=kCenter + 26,
                    w=50,h=kMax,
                    flags=kHAlignCenter+kVAlignCenter,
                },
                
                SetStyle(CreateTextStyle(FontGame, 34, BlackColor)),
                Text
                {
                    name="score",
                    x=20,y=kCenter + 18,
                    w=100, h=kMax,
                    flags=kHAlignCenter+kVAlignCenter,
                },
                
                SetStyle(CreateTextStyle(FontArial, 40, WhiteColorAlpha128)),
                Text
                {
                    name="sign",
                    x=kCenter,y=kCenter + 6,
                    --w=100, h=kMax,
                    flags=kHAlignCenter+kVAlignCenter,
                    label = "dollar_sign",
                },
            },
            
            Bitmap
            {
                x=515,
                y=kCenter + 6,
                name = "upgrade",
                image = "ui/buttons/upgrade_button_dis",
                
                SetStyle(CreatePushButtonStyle(UpgradeButtonGraphics, DefaultButtonSound)),
                Button
                {
                    x=0,
                    y=0,
                    name="upgradebutton",
                    command=
                    function()
                        DoModal("scripts/cde_panel_upgrade.lua");
                    end,
                    SetStyle(CreateTextStyle(FontGame, 18, BlackColor)),
                    CreateText(0,0,"upgrade",0,0),
                },
            },
            
            Bitmap
            {
                image = "ui/buttons/pause_buttonup",
                name = "underpause",
                x=661,
                y=28,
                alpha=true,
                SetStyle(CreateTextStyle(FontButtons, 26, WhiteColorAlpha128)),
                CreateText(2,2,"pause",7,0),
                SetStyle(CreateTextStyle(FontButtons, 26, BlackColor)),
                CreateText(0,0,"pause",7,0),
            },
                
            SetStyle(CreatePushButtonStyle(PauseButtonGraphics, DefaultButtonSound)),
            Button
            {
                x=661,
                y=28,
                name="pause",
                command=
                function()
                    DoModal("scripts/pause.lua");
                end,
                SetStyle(CreateTextStyle(FontButtons, 26, WhiteColorAlpha128)),
                CreateText(2,2,"pause",7,0),
                SetStyle(CreateTextStyle(FontButtons, 26, BlackColor)),
                CreateText(0,0,"pause",7,0),
            },
        },
               
        CDPanelTutorial
        {
            name = "cdpaneltutorial",

            x = 300,
            y = -1000,
            w = 800,
            h = 600,

            Bitmap
            {
                name="hint",
                image = "ui/surfaces/panel_tutorial",
                x=-1000,
                y=-1000,
                w = 800,
                h = 600,
                
                SetStyle(CreateTextStyle(FontComics, 24, BlackColor)),
                Text
                {
                    x=30,
                    y=10,
                    w = kMax-38,
                    h = kMax-10,
                    flags = kVAlignCenter + kHAlignCenter,
                    name="tutorialtext",
                },
            },
            SetStyle(CreatePushButtonStyle(StandardButtonGraphics, DefaultButtonSound)),
            Button
            {
                x=11,
                y=500,
                name="skip",
                flags=kHAlignLeft,
                command = function() 
                    SkipTutorial(); 
                    end,
			    SetStyle(CreateTextStyle(FontButtons, 26, WhiteColorAlpha128)),
			    CreateText(2,2,"skiptutorial", 0, 0),
			    SetStyle(CreateTextStyle(FontButtons, 26, BlackColor)),
			    CreateText(0,0,"skiptutorial", 0, 0),
            },
        },
    },
}
